/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.CreateEventLogData;
import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.HexDisplayerBean;
import com.ibm.hwmca.base.logd.HexInfo;
import com.ibm.hwmca.base.logd.LogDisplayer;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.logd.DisplayerExpander;
import com.ibm.hwmca.fw.logd.DisplayerExpanderData;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;

public class HexExpanderTasklet
extends DisplayerExpander
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDEHT";
    private static final String TRACE_MASKD = "XLOGDEHD";
    private static final String TRACE_MASKF = "XLOGDEHF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String HEX_PANEL_NAME = "HexDisplayerPanel";
    private HexDisplayerBean _hexDisplayerBean = new HexDisplayerBean();
    private CreateEventLogData _createEventLogData = new CreateEventLogData();
    private Log _logData;

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> HexExpanderTasklet.service()");
        if (taskletRequest.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "HexExpanderTasklet - doing InitialRequest");
            DisplayerExpanderData displayerExpanderData = this.retrieveExpanderData(taskletRequest, taskletResponse);
            if (!taskletResponse.isResponseSet()) {
                byte[] hexData = displayerExpanderData.getHexData();
                Trace.trace(TRACE_MASKF, "init  bean data for the hex displayer.");
                EventLogData eventLogData = this._createEventLogData.createEventLogData(displayerExpanderData.getLogData());
                HexInfo hexInfo = new HexInfo(eventLogData, hexData);
                this._hexDisplayerBean.setHexInfo(hexInfo);
                Trace.trace(TRACE_MASKF, "Display hex data");
                taskletResponse.openModalChild(AUIML_FILE_NAME, HEX_PANEL_NAME, this._hexDisplayerBean);
            }
        } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
            Trace.trace(TRACE_MASKF, "before the log terminate");
            taskletResponse.terminate();
        } else {
            String panelError = (String)taskletRequest.getData("panelError");
            if (panelError == null) {
                TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                String command = event.getActionCommand();
                String panelName = (String)taskletRequest.getData("panelName");
                Trace.trace(TRACE_MASKF, "Hex Displayer's command =" + command + " panelName=" + panelName);
                if (command.equals("OkButton")) {
                    taskletResponse.dispose();
                } else if (command.equals("CANCEL")) {
                    taskletResponse.dispose();
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown event received by the HexExpander panel. command=" + command);
                    taskletResponse.error(LogDisplayer._lUnknownEvent, null);
                }
            } else {
                Trace.trace(TRACE_MASKF, "HexExpanderTasklet panelErr=" + panelError);
                taskletResponse.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- HexExpanderTasklet.service()");
    }

    public DisplayerExpanderData retrieveExpanderData(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> HexExpanderTasklet.retrieveExpanderData()");
        super.service(taskletRequest, taskletResponse);
        DisplayerExpanderData displayerExpanderData = super.getData();
        Trace.trace(TRACE_MASKT, "<- HexExpanderTasklet.retrieveExpanderData()");
        return displayerExpanderData;
    }

    public void logException(Throwable e) {
        Trace.trace(TRACE_MASKT, "-> HexExpanderTasklet.logException()");
        Trace.trace(TRACE_MASKF, e);
        new FrameworkLog(_logInfo, 1362, e).log();
        Trace.trace(TRACE_MASKT, "<- HexExpanderTasklet.logException()");
    }
}

